/*
 * Decompiled with CFR 0.152.
 */
package lotr;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRBannerProtection;
import lotr.common.LOTRConfig;
import lotr.common.LOTRDimension;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPlayerData;
import lotr.common.LOTRPotions;
import lotr.common.LOTRReflection;
import lotr.common.LOTRTime;
import lotr.common.enchant.LOTREnchantment;
import lotr.common.enchant.LOTREnchantmentHelper;
import lotr.common.entity.Dragons.entity.LOTREntityDragonSmaug;
import lotr.common.entity.Dragons.entity.SmaugFireballs;
import lotr.common.entity.ai.DontSuffocateAI;
import lotr.common.entity.item.LOTREntityArrowDragon;
import lotr.common.entity.npc.LOTREntityDwarf;
import lotr.common.entity.npc.LOTREntityElf;
import lotr.common.entity.npc.LOTREntityEnt;
import lotr.common.entity.npc.LOTREntityMan;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityOrc;
import lotr.common.entity.npc.LOTREntityTroll;
import lotr.common.entity.npc.LOTREntityWarg;
import lotr.common.entity.projectile.LOTREntityCrossbowBolt;
import lotr.common.entity.projectile.LOTREntityDart;
import lotr.common.entity.projectile.LOTREntitySpear;
import lotr.common.entity.projectile.LOTREntityThrowingAxe;
import lotr.common.world.biome.LOTRBiome;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentThorns;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.world.BlockEvent;

public class LOTRPlayerDeathHandler {
    private Map<String, InventoryPlayer> invMap = new HashMap<String, InventoryPlayer>();
    private static final Random random = new Random();

    @SubscribeEvent
    public void handlePlayerDeath(LivingDeathEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            String playerUUID = player.func_110124_au().toString();
            if (this.shouldSaveInventory(player)) {
                this.savePlayerInventory(player, playerUUID);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDeath(LivingDeathEvent event) {
        if (!(event.source.func_76346_g() instanceof EntityPlayer) || !(event.entity instanceof EntityLivingBase)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
        EntityLivingBase target = (EntityLivingBase)event.entity;
        ItemStack weapon = player.func_70694_bm();
        if (weapon == null || !LOTREnchantmentHelper.hasEnchant(weapon, LOTREnchantment.vampireStrike)) {
            return;
        }
        if (target instanceof EntityPlayer) {
            player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 240, 1));
            return;
        }
        if (player.field_70170_p.field_73012_v.nextFloat() < 0.15f) {
            player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 240, 1));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerSleep(PlayerSleepInBedEvent event) {
        final EntityPlayer player = event.entityPlayer;
        if (!player.field_70170_p.field_72995_K) {
            if (LOTRConfig.alwaysSetBedSpawn) {
                player.func_71063_a(new ChunkCoordinates(event.x, event.y, event.z), false);
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tile.bed.respawnSet")));
            }
            if (LOTRConfig.checkBedUnsafe && player.field_70170_p.field_73011_w.field_76574_g == LOTRDimension.MIDDLE_EARTH.dimensionID) {
                int width = 8;
                int height = 5;
                final LOTRPlayerData data = LOTRLevelData.getData(player);
                List entities = player.field_70170_p.func_94576_a((Entity)player, AxisAlignedBB.func_72330_a((double)(event.x - width), (double)(event.y - height), (double)(event.z - width), (double)(event.x + width), (double)(event.y + height), (double)(event.z + width)), new IEntitySelector(){

                    public boolean func_82704_a(Entity entity) {
                        if (entity instanceof LOTREntityNPC) {
                            LOTREntityNPC npc = (LOTREntityNPC)entity;
                            if (npc.func_70638_az() == player) {
                                return true;
                            }
                            float alignment = data.getAlignment(LOTRMod.getNPCFaction((Entity)npc));
                            return alignment < 0.0f;
                        }
                        return false;
                    }
                });
                if (!entities.isEmpty()) {
                    event.result = EntityPlayer.EnumStatus.NOT_SAFE;
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (!(event.entity instanceof LOTREntityNPC)) {
            return;
        }
        if (LOTRConfig.ridersAvoidSuffocation) {
            DontSuffocateAI.applyDontSuffocate(event.entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurt(LivingHurtEvent event) {
        Entity sourceEntity;
        Entity entity = event.entity;
        EntityLivingBase entityLiving = event.entityLiving;
        World world = entity.field_70170_p;
        DamageSource source = event.source;
        if (world.field_72995_K) {
            return;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            this.handleTotemUsage(player, event);
            if (source == DamageSource.field_76379_h) {
                this.handleFallDamage(player, event);
            }
        }
        if ((sourceEntity = source.func_76364_f()) instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sourceEntity;
            this.handleVampireStrike(player, event);
            this.handleMeleeDamageBoost(player, entityLiving, event);
            this.handleExplodeArmor(player, event);
        }
        this.handlePotionEffects(entityLiving, event);
        if (sourceEntity instanceof EntityArrow) {
            this.handleArrowDamageBoost(sourceEntity, entityLiving, event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurt31(LivingHurtEvent event) {
        if (!LOTRConfig.enableCloth || !(event.entity instanceof EntityPlayer) || event.entity.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        if (!player.field_70170_p.field_72995_K && player.func_70644_a(LOTRPotions.blood)) {
            boolean usedCloth = false;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = player.field_71071_by.func_70301_a(i);
                if (itemStack == null || itemStack.func_77973_b() != LOTRMod.cloth2) continue;
                player.field_70170_p.func_72956_a((Entity)player, "lotr:bandage", 1.0f, 1.0f);
                player.field_71071_by.func_70298_a(i, 1);
                player.func_70606_j(Math.min(player.func_110138_aP(), player.func_110143_aJ() + 2.0f));
                usedCloth = true;
                break;
            }
            if (usedCloth) {
                player.func_82170_o(LOTRPotions.blood.field_76415_H);
                event.setCanceled(true);
            }
        }
    }

    private void handleTotemUsage(EntityPlayer player, LivingHurtEvent event) {
        if (!(event.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player1 = (EntityPlayer)event.entity;
        if (player1.field_70170_p.field_72995_K) {
            return;
        }
        float damageAmount = event.ammount;
        int armorValue = player1.func_70658_aO();
        float damageReduction = (float)armorValue * 0.04f;
        float actualDamage = damageAmount * (1.0f - damageReduction);
        actualDamage = Math.max(actualDamage, 1.0f);
        if (player1.func_110143_aJ() - actualDamage <= 1.0f || damageAmount >= player1.func_110143_aJ()) {
            ItemStack itemStack;
            int i;
            boolean usedTotem = false;
            for (i = 0; i < player1.field_71071_by.func_70302_i_(); ++i) {
                itemStack = player1.field_71071_by.func_70301_a(i);
                if (itemStack == null || itemStack.func_77973_b() != LOTRMod.totemOfUndyingPlus) continue;
                player1.field_70170_p.func_72908_a(player1.field_70165_t, player1.field_70163_u, player1.field_70161_v, "lotr:misc.totem", 1.0f, 1.0f);
                for (Potion potion : Potion.field_76425_a) {
                    if (potion == null || !LOTRReflection.isBadEffect(potion)) continue;
                    player1.func_82170_o(potion.field_76415_H);
                }
                player1.func_70606_j(Math.min(player1.func_110138_aP(), 10.0f));
                if (player1.func_110143_aJ() <= 0.0f) {
                    player1.func_70606_j(1.0f);
                }
                player1.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 1200, 0));
                player1.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 1200, 0));
                player1.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 600, 0));
                LOTRLevelData.getData(player1).addAchievement(LOTRAchievement.usetotemOfUndying);
                if (itemStack.func_77984_f()) {
                    itemStack.func_96631_a(1, player1.func_70681_au());
                    if (itemStack.func_77960_j() >= itemStack.func_77958_k()) {
                        player1.field_71071_by.func_70299_a(i, null);
                    }
                }
                event.setCanceled(true);
                usedTotem = true;
                break;
            }
            if (!usedTotem) {
                for (i = 0; i < player1.field_71071_by.func_70302_i_(); ++i) {
                    itemStack = player1.field_71071_by.func_70301_a(i);
                    if (itemStack == null || itemStack.func_77973_b() != LOTRMod.totemOfUndying) continue;
                    player1.field_70170_p.func_72908_a(player1.field_70165_t, player1.field_70163_u, player1.field_70161_v, "lotr:misc.totem", 1.0f, 1.0f);
                    for (Potion potion : Potion.field_76425_a) {
                        if (potion == null || !LOTRReflection.isBadEffect(potion)) continue;
                        player1.func_82170_o(potion.field_76415_H);
                    }
                    player1.func_70606_j(Math.min(player1.func_110138_aP(), 8.0f));
                    if (player1.func_110143_aJ() <= 0.0f) {
                        player1.func_70606_j(1.0f);
                    }
                    LOTRLevelData.getData(player1).addAchievement(LOTRAchievement.usetotemOfUndying);
                    player1.field_71071_by.func_70298_a(i, 1);
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }

    private void handleFallDamage(EntityPlayer player, LivingHurtEvent event) {
        boolean significantFall;
        if (!(event.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player1 = (EntityPlayer)event.entity;
        int i = MathHelper.func_76128_c((double)player1.field_70165_t);
        int k = MathHelper.func_76128_c((double)player1.field_70161_v);
        World world = player1.field_70170_p;
        float damageAmount = event.ammount;
        BiomeGenBase biome = world.func_72807_a(i, k);
        if (player1.field_70170_p.field_72995_K || !(biome instanceof LOTRBiome) || player1.field_71075_bZ.field_75098_d) {
            return;
        }
        boolean highFall = (double)player1.field_70143_R > 32.0;
        boolean bl = significantFall = (double)player1.field_70143_R > 20.0 && damageAmount > 18.0f;
        if (damageAmount > 15.0f && damageAmount < 32.0f && player1.func_110143_aJ() - damageAmount <= 2.0f && highFall) {
            player1.field_70170_p.func_72956_a((Entity)player1, "lotr:misc.bone", 0.8f, 0.9f);
            LOTRLevelData.getData(player1).addAchievement(LOTRAchievement.highground);
        }
        if (significantFall) {
            player1.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 600, 2));
            player1.func_70690_d(new PotionEffect(LOTRPotions.vulnerability.field_76415_H, 1200, 0));
            player1.func_70690_d(new PotionEffect(LOTRPotions.broken.field_76415_H, 2400, 0));
            player1.field_70170_p.func_72956_a((Entity)player1, "lotr:misc.bone", 0.8f, 0.9f);
        }
    }

    private void handleVampireStrike(EntityPlayer player, LivingHurtEvent event) {
        ItemStack weapon = player.func_70694_bm();
        if (weapon == null || !LOTREnchantmentHelper.hasEnchant(weapon, LOTREnchantment.vampireStrike)) {
            return;
        }
        if (player.field_70170_p.field_73012_v.nextFloat() < 0.08f) {
            float healAmount = Math.min(event.ammount, 2.0f);
            player.func_70691_i(healAmount);
        }
    }

    private void handleMeleeDamageBoost(EntityPlayer player, EntityLivingBase target, LivingHurtEvent event) {
        boolean hasRelevantEffect;
        boolean bl = hasRelevantEffect = player.func_70644_a(LOTRPotions.meleeDamageBoost) || player.func_70644_a(LOTRPotions.dragon) || player.func_70644_a(LOTRPotions.meleeDamageBoostSauron);
        if (!hasRelevantEffect) {
            return;
        }
        if (!this.isTargetOfType(target, LOTREntityElf.class, LOTREntityOrc.class, EntityDragon.class, LOTREntityTroll.class, LOTREntityWarg.class, LOTREntityMan.class, LOTREntityDwarf.class, LOTREntityEnt.class)) {
            return;
        }
        if (this.isTargetOfType(target, LOTREntityElf.class, LOTREntityOrc.class, EntityDragon.class, LOTREntityTroll.class, LOTREntityWarg.class)) {
            this.applyPotionDamageBoost(player, LOTRPotions.meleeDamageBoost, event, 2.0f);
        }
        if (target instanceof EntityDragon) {
            this.applyPotionDamageBoost(player, LOTRPotions.dragon, event, 3.5f);
        }
        if (this.isTargetOfType(target, LOTREntityElf.class, LOTREntityMan.class, LOTREntityDwarf.class, LOTREntityEnt.class, EntityDragon.class)) {
            this.applyPotionDamageBoost(player, LOTRPotions.meleeDamageBoostSauron, event, 2.0f);
        }
    }

    private boolean isTargetOfType(EntityLivingBase target, Class<?> ... types) {
        for (Class<?> type : types) {
            if (!type.isInstance(target)) continue;
            return true;
        }
        return false;
    }

    private void applyPotionDamageBoost(EntityPlayer player, Potion potion, LivingHurtEvent event, float extraDamage) {
        if (player.func_70644_a(Potion.field_76425_a[potion.field_76415_H])) {
            event.ammount += extraDamage;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurtEnchant(LivingHurtEvent event) {
        if (event.entityLiving instanceof EntityPlayer && event.source.func_76364_f() != null) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            int levell = this.getEnchantmentLevelByInstance(player, LOTREnchantment.thornArmor);
            if ((double)player.field_70170_p.field_73012_v.nextFloat() < (double)levell * 0.08) {
                float dmg = event.ammount;
                event.source.func_76364_f().func_70097_a(DamageSource.func_92087_a((Entity)player), (float)EnchantmentThorns.func_92095_b((int)((int)dmg * 2), (Random)player.func_70681_au()));
            }
        }
    }

    private void handleExplodeArmor(EntityPlayer player, LivingHurtEvent event) {
        int enchantmentLevel = this.getEnchantmentLevelByInstance(player, LOTREnchantment.explodeArmor);
        if (enchantmentLevel <= 0) {
            return;
        }
        float damageMultiplier = 1.0f;
        if (event.source.func_94541_c()) {
            damageMultiplier = 0.35f;
        } else if (event.source.func_76364_f() instanceof SmaugFireballs) {
            damageMultiplier = 0.1f;
        } else if (event.source.func_76364_f() instanceof EntityDragon) {
            damageMultiplier = 0.1f;
        }
        if (damageMultiplier < 1.0f) {
            event.ammount *= damageMultiplier;
        }
    }

    private void handlePotionEffects(EntityLivingBase entityLiving, LivingHurtEvent event) {
        if (entityLiving.func_70644_a(LOTRPotions.luck)) {
            float chanceToIgnore;
            int luckLevel = entityLiving.func_70660_b(LOTRPotions.luck).func_76458_c();
            float f = chanceToIgnore = luckLevel > 0 ? 0.35f : 0.25f;
            if (random.nextFloat() < chanceToIgnore) {
                event.setCanceled(true);
                return;
            }
        }
        if (entityLiving.func_70644_a(LOTRPotions.unluck)) {
            float chanceToIncreaseDamage;
            int unluckLevel = entityLiving.func_70660_b(LOTRPotions.unluck).func_76458_c();
            float damageMultiplier = unluckLevel > 0 ? 1.5f : 1.25f;
            float f = chanceToIncreaseDamage = unluckLevel > 0 ? 0.35f : 0.25f;
            if (random.nextFloat() < chanceToIncreaseDamage) {
                event.ammount *= damageMultiplier;
            }
        }
    }

    private void handleArrowDamageBoost(Entity sourceEntity, EntityLivingBase target, LivingHurtEvent event) {
        if ((sourceEntity instanceof EntityArrow || sourceEntity instanceof LOTREntityDart || sourceEntity instanceof LOTREntitySpear || sourceEntity instanceof LOTREntityThrowingAxe || sourceEntity instanceof LOTREntityCrossbowBolt) && target instanceof EntityDragon) {
            Potion potion;
            EntityPlayer player;
            EntityDragon dragon = (EntityDragon)target;
            Entity shooter = ((EntityArrow)sourceEntity).field_70250_c;
            if (shooter instanceof EntityPlayer && (player = (EntityPlayer)shooter).func_70644_a(potion = Potion.field_76425_a[LOTRPotions.dragon.field_76415_H])) {
                event.ammount += 5.0f;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void register(BlockEvent.BreakEvent event) {
        if (event.block == null || event.world == null || event.getPlayer() == null || event.getPlayer().func_70694_bm() == null) {
            return;
        }
        ItemStack item = event.getPlayer().func_70694_bm();
        World world = event.world;
        EntityPlayer player = event.getPlayer();
        if (LOTREnchantmentHelper.hasEnchant(item, LOTREnchantment.lumberjack) && event.block.isWood((IBlockAccess)world, event.x, event.y, event.z) && player.func_70093_af()) {
            this.breakTree(world, player, event.x, event.y, event.z);
        }
    }

    void breakTree(World world, EntityPlayer player, int x, int y, int z) {
        LinkedList<int[]> queue = new LinkedList<int[]>();
        HashSet<String> visited = new HashSet<String>();
        queue.add(new int[]{x, y, z});
        visited.add(x + "," + y + "," + z);
        int[][] directions = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}, {0, 0, 1}, {0, 0, -1}, {1, 1, 0}, {-1, 1, 0}, {0, 1, 1}, {0, 1, -1}, {1, -1, 0}, {-1, -1, 0}, {0, -1, 1}, {0, -1, -1}, {1, 0, 1}, {1, 0, -1}, {-1, 0, 1}, {-1, 0, -1}, {1, 1, 1}, {-1, 1, 1}, {1, -1, 1}, {-1, -1, 1}, {1, 1, -1}, {-1, 1, -1}, {1, -1, -1}, {-1, -1, -1}, {0, 2, 0}, {0, -2, 0}, {2, 0, 0}, {-2, 0, 0}, {0, 0, 2}, {0, 0, -2}, {1, 2, 0}, {-1, 2, 0}, {0, 2, 1}, {0, 2, -1}, {1, -2, 0}, {-1, -2, 0}, {0, -2, 1}, {0, -2, -1}, {2, 1, 0}, {-2, 1, 0}, {2, -1, 0}, {-2, -1, 0}, {0, 1, 2}, {0, -1, 2}, {0, 1, -2}, {0, -1, -2}, {1, 0, 2}, {-1, 0, 2}, {1, 0, -2}, {-1, 0, -2}};
        int maxHeight = 50;
        int maxRadius = 2;
        while (!queue.isEmpty()) {
            int currZ;
            int currY;
            int[] pos = (int[])queue.poll();
            int currX = pos[0];
            Block block = world.func_147439_a(currX, currY = pos[1], currZ = pos[2]);
            if (!block.isWood((IBlockAccess)world, currX, currY, currZ) || LOTRBannerProtection.isProtected(world, currX, currY, currZ, LOTRBannerProtection.forPlayer(player), false) || Math.abs(currY - y) > maxHeight || Math.abs(currX - x) > maxRadius || Math.abs(currZ - z) > maxRadius) continue;
            if (player.func_70694_bm().func_96631_a(1, world.field_73012_v)) {
                return;
            }
            this.breakBlock(world, player, currX, currY, currZ);
            for (int[] dir : directions) {
                int newX = currX + dir[0];
                int newY = currY + dir[1];
                int newZ = currZ + dir[2];
                String key = newX + "," + newY + "," + newZ;
                if (visited.contains(key) || !world.func_147439_a(newX, newY, newZ).isWood((IBlockAccess)world, newX, newY, newZ)) continue;
                queue.add(new int[]{newX, newY, newZ});
                visited.add(key);
            }
        }
    }

    void breakBlock(World world, EntityPlayer player, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        block.func_149681_a(world, x, y, z, meta, player);
        if (block.removedByPlayer(world, player, x, y, z, true)) {
            block.func_149664_b(world, x, y, z, meta);
            block.func_149636_a(world, player, x, y, z, meta);
        }
        world.func_147468_f(x, y, z);
        if (!world.field_72995_K) {
            world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
        }
    }

    @SubscribeEvent
    public void onPlayerWakeUp(PlayerWakeUpEvent event) {
        EntityPlayer player = event.entityPlayer;
        World world = player.field_70170_p;
        int i = (int)player.field_70165_t;
        int j = (int)player.field_70163_u;
        int k = (int)player.field_70161_v;
        long worldTime = LOTRTime.getWorldTime();
        if (!world.field_72995_K) {
            LOTRLevelData.getData(player).addAchievement(LOTRAchievement.sweetDreams);
        }
        if (world.field_72995_K) {
            if (worldTime % (long)LOTRTime.DAY_LENGTH >= 0L && worldTime % (long)LOTRTime.DAY_LENGTH <= 20000L) {
                for (int l = 0; l < 10; ++l) {
                    double d0 = player.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * 2.0;
                    double d1 = player.field_70163_u + world.field_73012_v.nextDouble() * 2.0;
                    double d2 = player.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * 2.0;
                    world.func_72869_a("heart", d0, d1, d2, 0.0, 0.0, 0.0);
                    player.func_70606_j(player.func_110138_aP());
                }
                world.func_72980_b((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "lotr:misc.sleep", 0.5f, 1.0f, false);
            } else {
                for (int l = 0; l < 10; ++l) {
                    double d0 = player.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * 2.0;
                    double d1 = player.field_70163_u + world.field_73012_v.nextDouble() * 2.0;
                    double d2 = player.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * 2.0;
                    world.func_72869_a("crit", d0, d1, d2, 0.0, 0.0, 0.0);
                    world.func_72980_b((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "game.player.hurt", 0.9f, 1.0f, false);
                }
            }
        }
    }

    public int getEnchantmentLevelByInstance(EntityPlayer player, LOTREnchantment targetEnchantInstance) {
        int totalLevel = 0;
        for (int slot = 1; slot <= 4; ++slot) {
            if (player.func_71124_b(slot) == null) continue;
            List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(player.func_71124_b(slot));
            for (LOTREnchantment ench : enchants) {
                if (ench != targetEnchantInstance) continue;
                ++totalLevel;
            }
        }
        return totalLevel;
    }

    @SubscribeEvent
    public void handlePlayerDrops(PlayerDropsEvent event) {
        EntityPlayer player = event.entityPlayer;
        String playerUUID = player.func_110124_au().toString();
        if (this.invMap.containsKey(playerUUID)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handlePlayerClone(PlayerEvent.Clone event) {
        EntityPlayer original = event.original;
        EntityPlayer player = event.entityPlayer;
        String playerUUID = original.func_110124_au().toString();
        if (this.invMap.containsKey(playerUUID)) {
            System.out.println("Restoring inventory for player: " + playerUUID);
            player.field_71071_by.func_70455_b(this.invMap.get(playerUUID));
            this.invMap.remove(playerUUID);
        }
    }

    private boolean shouldSaveInventory(EntityPlayer player) {
        ItemStack stack;
        int i;
        int size;
        if (LOTRConfig.enableSoulboundClover || player.field_71071_by.func_146028_b(LOTRMod.magicCloverPlus)) {
            size = player.field_71071_by.func_70302_i_();
            for (i = 0; i < size; ++i) {
                stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != LOTRMod.magicCloverPlus) continue;
                stack.func_77972_a(1, (EntityLivingBase)player);
                if (stack.func_77960_j() >= stack.func_77958_k()) {
                    player.field_71071_by.func_70299_a(i, null);
                }
                return true;
            }
        } else if (player.field_71071_by.func_146028_b(LOTRMod.magicClover)) {
            LOTRLevelData.getData(player).addAchievement(LOTRAchievement.usemagicClover);
            player.field_71071_by.func_146026_a(LOTRMod.magicClover);
            return true;
        }
        size = player.field_71071_by.func_70302_i_();
        for (i = 0; i < size; ++i) {
            stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !LOTRPlayerDeathHandler.hasEnchantment(stack, "soulbound")) continue;
            return true;
        }
        return false;
    }

    private void savePlayerInventory(EntityPlayer player, String playerUUID) {
        System.out.println("Saving inventory for player: " + playerUUID);
        InventoryPlayer inv = new InventoryPlayer(player);
        inv.func_70455_b(player.field_71071_by);
        this.invMap.put(playerUUID, inv);
        player.field_71071_by.func_146027_a(null, -1);
    }

    public static boolean hasEnchantment(ItemStack stack, String enchantmentName) {
        NBTTagList list;
        if (stack != null && stack.func_77942_o() && (list = stack.func_77986_q()) != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                short enchantmentId;
                String enchantment;
                NBTTagCompound nbt = list.func_150305_b(i);
                if (nbt == null || !nbt.func_74764_b("id") || (enchantment = Enchantment.field_77331_b[enchantmentId = nbt.func_74765_d("id")].func_77320_a()) == null || !enchantment.contains(enchantmentName)) continue;
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onLivingHeal2(LivingHealEvent event) {
        World world = event.entityLiving.field_70170_p;
        EntityLivingBase entityLiving = event.entityLiving;
        float multiplier = 1.0f;
        if (event.amount <= 1.0f) {
            if (entityLiving.func_82165_m(LOTRPotions.blood.field_76415_H)) {
                multiplier = 0.7f;
            } else if (entityLiving.func_82165_m(LOTRPotions.infection.field_76415_H) || entityLiving.func_82165_m(LOTRPotions.vulnerability.field_76415_H)) {
                multiplier = 0.0f;
            }
        }
        event.amount *= multiplier;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurtBowDamageBoost(LivingHurtEvent event) {
        if (!(event.source.func_76364_f() instanceof EntityArrow)) {
            return;
        }
        EntityArrow arrow = (EntityArrow)event.source.func_76364_f();
        if (arrow instanceof LOTREntityArrowDragon) {
            return;
        }
        if (!(arrow.field_70250_c instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)arrow.field_70250_c;
        if (!player.func_70644_a(LOTRPotions.bowDamageBoost)) {
            return;
        }
        int amplifier = player.func_70660_b(LOTRPotions.bowDamageBoost).func_76458_c();
        event.ammount *= (float)(amplifier + 1) * 1.5f;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingHurtBowDamageBoost2(LivingHurtEvent event) {
        if (!(event.source.func_76364_f() instanceof LOTREntityArrowDragon)) {
            return;
        }
        LOTREntityArrowDragon arrow = (LOTREntityArrowDragon)event.source.func_76364_f();
        if (!(arrow.field_70250_c instanceof EntityPlayer)) {
            return;
        }
        Entity target = event.entity;
        if (target instanceof LOTREntityDragonSmaug) {
            event.ammount += 500.0f;
        } else if (target instanceof EntityDragon) {
            event.ammount += 65.0f;
        }
    }

    @SubscribeEvent
    public void handleEntityJoinWorld(EntityJoinWorldEvent event) {
        EntityPlayer player;
        String playerUUID;
        if (event.entity instanceof EntityPlayer && event.entity.func_70089_S() && this.invMap.containsKey(playerUUID = (player = (EntityPlayer)event.entity).func_110124_au().toString())) {
            System.out.println("Restoring inventory for player: " + playerUUID);
            player.field_71071_by.func_70455_b(this.invMap.get(playerUUID));
            this.invMap.remove(playerUUID);
        }
    }
}

